/**
 * \file: ald_init.c
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * \component: authorization level daemon
 *
 * \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
 *
 * \copyright (c) 2017 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 *
 ***********************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <stdbool.h>
#include <string.h>

#define BINARY_NAME "ald_init"

#include "ald_init.h"
#include "util/version_info.h"
#include "util/helper.h"
#include "init_daemon_state_cmd/init_daemon_state_cmd.h"
#include "create_signature_db_cmd/create_signature_db_cmd.h"
#include "create_keys_cmd/create_keys_cmd.h"

static command_vtable_t *ald_init_cmd_list[]=
{
		&init_daemon_state_cmd_vtable,
		&create_signature_db_cmd_vtable,
		&create_keys_cmd_vtable
};

static void ald_init_printusage(const char *binary_name);
static void ald_init_printhelp(const char *binary_name,
                               command_vtable_t *commands[],
                               size_t commands_len);
static void ald_init_printversion(const char *binary_name);

//----------------------------------------------- device sync api members ----------------------------------------------
error_code_t ald_init_init(int argc, char *argv[],command_vtable_t **current_cmd )
{
	error_code_t result;

    result = helper_find_parse_init_command(
                                argc, argv,
                                ald_init_cmd_list, ARRAY_SIZE(ald_init_cmd_list),
                                BINARY_NAME,
                                &ald_init_printhelp,
                                &ald_init_printversion,
                                &ald_init_printusage,
                                current_cmd);

	return result;
}

error_code_t ald_init_start(command_vtable_t *current_cmd)
{
    if ((current_cmd != NULL) && (current_cmd->start != NULL))
		return current_cmd->start();

	return RESULT_OK;
}

void ald_init_deinit(command_vtable_t *current_cmd)
{  
    if ((current_cmd != NULL) && (current_cmd->deinit != NULL))
			current_cmd->deinit();
}

void ald_init_error_message(error_code_t err)
{
	if (err==RESULT_NORESOURCE)
		fprintf(stderr, "Error: Out of memory.");
}
//-------------------------------------------------------------------------------------------------------------------------

//------------------------------------------- private members -------------------------------------------------------------
static void ald_init_printhelp(const char *binary_name,
                               command_vtable_t *commands[],
                               size_t commands_len)
{
	size_t idx;
	printf("\n");
	printf("Authorization Level Daemon Initialization Utility - Used to create configurations and\n"
			"signatures for the ADIT authorization level daemon.\n\n");
	printf("%s [<COMMAND>] [OPTIONS]\n", binary_name);
	printf("\t-h, --help\tDisplays some help and exits\n");
	printf("\t-v, --version\tDisplays version information and exits\n\n");
	printf("Supported commands:\n");
	for (idx=0; idx<commands_len; idx++)
		printf("\t%20s \t%s\n",commands[idx]->command, commands[idx]->command_description);
	printf("\nUse %s <COMMAND> --help to get more information on \nthe usage of the respective command.\n\n", binary_name);
}

static void ald_init_printusage(const char *binary_name)
{
	printf("\n");
	printf("%s [<COMMAND>] [OPTIONS]\n", binary_name);
	printf("\t-h, --help\tDisplays some help and exits.\n");
	printf("\t-v, --version\tDisplays version information and exits.\n\n");
}

static void ald_init_printversion(const char *binary_name)
{
	printf("%s - %s\n", binary_name, VERSION_INFO_FORMATED_LINE);
}
//-------------------------------------------------------------------------------------------------------------------------
